uniform sampler2D wave;
uniform int isRgb;
uniform vec4 colorBass;
uniform vec4 colorMed;
uniform vec4 colorHigh;

vec4 skinSongPos(vec2 uv)
{
	vec4 color = texture2D(wave, uv.xy);
	float volume = color.a;
	color.a = 1.0;
	float h = abs(uv.y*2.0-1.0);
	if (isRgb!=0)
	{
		if (h > volume)
			return vec4(0.0,0.0,0.0,0.0);
		else
		{
			if (isRgb==3) // infra-red
			{
				vec4 lmh = color;
				color.r = lmh.r + lmh.b*0.5 - lmh.g*0.25;
				color.g = lmh.b;
				color.b = lmh.g + lmh.b*0.5 - lmh.r*0.5;
			}
			else if (isRgb==2) // ultra-blue
			{
				float swap = color.r;
				color.r = color.b;
				color.b = swap;
			}
			float d = h / volume;
			if (d>0.5)
			{
				float a = 2.0*d-1.0;
				return color * (1.0-0.5*a*a);
			}
			else
				return color;
		}
	}
	else
	{
		float hbass = max(max(color.r, color.g), color.b) * volume;
		float hmed = max(color.g, color.b) * volume;
		float hhigh = color.b * volume;
		if (h > hbass)
			return vec4(0.0,0.0,0.0,0.0);
		else if (h > hmed)
		{
			float d = (h-hmed)/(hbass-hmed);
			if (d>0.8)
				return colorBass * (3.0-2.5*d);
			else if (d<0.1)
				return mix(colorMed, colorBass, 0.5+5.0*d);
			else
				return colorBass;
		}
		else if (h > hhigh)
		{
			float d = (h-hhigh)/(hmed-hhigh);
			if (d>0.9)
				return mix(colorBass, colorMed, 5.5-5.0*d);
			else if (d<0.1)
				return mix(colorHigh, colorMed, 0.5+5.0*d);
			else
				return colorMed;
		}
		else
		{
			float d = h/hhigh;
			if (d>0.9)
				return mix(colorMed, colorHigh, 5.5-5.0*d);
			else
				return colorHigh;
		}
	}
}

void main()
{
	gl_FragColor = skinSongPos(gl_TexCoord[0].st);
}
